import java.lang.*;
import java.util.*;
import java.io.*;
import javax.imageio.*;
import javax.imageio.stream.*; 
import javax.imageio.plugins.jpeg.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.awt.Toolkit.*;
import java.awt.datatransfer.*;

class abstract_fractalc {
  int mode;
  int max_iter_pow2;
  static int MANDELBROT_MODE = 0;
  static int JULIA_MODE = 1;

  double view_x_m;
  double view_w_m;
  double view_y_m;
  double view_h_m;


  double view_x;
  double view_w;
  double view_y;
  double view_h;

  //int max_iter_pow2;
  int fractal_type;

  abstract_fractalc() {
    max_iter_pow2 = 8;
    view_x = -1.6;
    view_w = 1.0;
    view_y = -1.0;
    view_h = 0.75;
    view_x_m = view_x;
    view_y_m = view_y;
    view_w_m = view_w;
    view_h_m = view_h;
    mode = MANDELBROT_MODE;
    
  }

  int get_fractal_type() {
    return fractal_type;
  }

  boolean is_julia_mode_on() {
    if (mode == JULIA_MODE) {return true;}
    return false;
  }
  boolean is_mandelbrot_mode_on() {
    if (mode == MANDELBROT_MODE) {return true;}
    return false;
  }
  void reset_view() {
    view_x = -1.3333;
    view_w = 2.6666;
    view_y = -1.0;
    view_h = 2.0;
  }
  void use_julia_mode() {
    view_x_m = view_x;
    view_y_m = view_y;
    view_w_m = view_w;
    view_h_m = view_h;
    mode = JULIA_MODE;
    reset_view();
  }
  void use_mandelbrot_mode() {
    view_x = view_x_m;
    view_y = view_y_m;
    view_w = view_w_m;
    view_h = view_h_m;
    mode = MANDELBROT_MODE;
  }
  int calc_point(double x,double y,int max_iter){
    return 0;
  }
  void print_mode() {
    if (mode == MANDELBROT_MODE) {
      System.out.println("mandelbrot mode");
    }
    if (mode == JULIA_MODE) {
      System.out.println("julia mode");
    }
  }
  //void read2(FractalInputStream i) throws IOException {    
  //}  
  void read(DataInputStream i) throws IOException {
  }
  void write(DataOutputStream o) throws IOException {
  }
  void prev_mode() {  
  }
  void next_mode() {    
  }
  void random(long seed) {
  }
  String get_status_text() {
    return "";
  }
  static abstract_fractalc get_new_fractal(int t) {
    abstract_fractalc f = null;
    if ((t >= 1400000002) & (t <= 1400001000)) {
      f = new fractal_params_c(t-1400000000);
    }
    if (f != null) {
      f.fractal_type = t;
    }
    return f;
  }
}

class fractal_params4_c extends fractal_params_c {
  fractal_params4_c() {
    super(4);
  }
}
class fractal_params_c extends abstract_fractalc {
  //int max_iter_pow2;
  int mode2;
  double param_real[];
  double param_img[];
  //double param_real2[];
  //double param_img2[];
  int num_params;
  fractal_params_c(int np) {
    max_iter_pow2 = 6;
    param_real = new double[np];
    param_img = new double[np];
    for (int i = 0;i < np;i++) {
      param_real[i] = 0;
      param_img[i] = 0;
    }
    mode2 = 0;
    num_params = np;
  }
  String get_status_text() {
    if (mode2 == 0) {
      return "p";
    } else if (mode2 == 1) {
      return "x*p";
    } else {
      return "(x^"+mode2+")*p";
    }
  }
  void random(long seed) {    
    Random rand = new Random();
    rand.setSeed(seed);
    for (int i = 2;i < num_params;i++) {
      double f1 = rand.nextDouble();
      double f2 = rand.nextDouble();
      param_real[i] = Math.cos(f1 * Math.PI * 2) * f2*2;
      param_img[i] = Math.sin(f1 * Math.PI * 2) * f2*2;
    }
    use_mandelbrot_mode();
    reset_view();
  }
  //void read2(FractalInputStream i) throws IOException {
  //  i.readInt();
  //  i.readInt();
  //  mode2 = i.readInt();
  //  for (int i2 = 0;i2 < num_params;i2++) {
  //    param_real[i2] = i.readDouble10();
  //    param_img[i2] = i.readDouble10();
  //  }
  //}
  void read(DataInputStream i) throws IOException {
    i.readInt();
    i.readInt();
    i.readInt();
    i.readInt();

    i.readInt();
    i.readInt();
    i.readInt();
    i.readInt();
    i.readUnsignedShort();
    mode2 = i.readUnsignedShort();
    for (int i2 = 0;i2 < num_params;i2++) {
      param_real[i2] = i.readDouble();
      param_img[i2] = i.readDouble();
    }

  }
  void write(DataOutputStream o) throws IOException {
    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);

    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);
    o.writeShort(0);
    o.writeShort(mode2);
    for (int i = 0;i < num_params;i++) {
      o.writeDouble(param_real[i]);
      o.writeDouble(param_img[i]);
    }
  }

  void prev_mode() {  
    save_mode();
    if (mode2 > 0) {
      mode2 = mode2 - 1;
    }
    restore_mode();
  }
  void next_mode() {    
    save_mode();
    if (mode2 < (num_params - 1)) {
      mode2 = mode2 + 1;
    }
    restore_mode();  
  }
  void save_mode() {
    param_real[mode2] = view_x + (view_w * 0.5);
    param_img[mode2] = view_y + (view_h * 0.5);  
  }
  void restore_mode() {
    view_x = param_real[mode2] - (view_w * 0.5);
    view_y = param_img[mode2] - (view_h * 0.5);
  }
  int calc_point(double x,double y,int max_iter) {
    int i = 0;
    double x2 = 0;
    double y2 = 0;
    double param_real2[] = new double[num_params];
    double param_img2[] = new double[num_params];
    for (int i2 = 0;i2 < num_params;i2++) {
      param_real2[i2] = param_real[i2];
      param_img2[i2] = param_img[i2];
    }
    if (is_julia_mode_on() == true) {
      x2 = x;
      y2 = y;
    } else {
      param_real2[mode2] = x;
      param_img2[mode2] = y;
    }
    double x3 = 0;
    double y3 = 0;
    double x4 = 0;
    double y4 = 0;
    double xy = 0;
    double d = 0;
    double xy2 = 0;
    double b = Math.exp(Math.log(2)*num_params);
    while (i < max_iter) {
      d = (x2*x2)+(y2*y2);
      if (d >= b) {break;}
      x4 = x2;
      y4 = y2; 
      for (int i2 = num_params-1;i2 > 0;i2--) { 
        x3 = x4 + param_real2[i2];
        y3 = y4 + param_img2[i2];
        x4 = (x3*x2)-(y3*y2);
        y4 = (x3*y2)+(x2*y3);
      }
      x2 = x4 + param_real2[0];
      y2 = y4 + param_img2[0];
      i = i + 1;
    }  
    //total_iter = total_iter + i;
    return i;  
  }
}
class fractal_thread extends Thread {
  short fractal_image[][];
  int width = 0;
  int height = 0;
  int new_width = 0;
  int new_height = 0;
  int flags;
  int id;
  int zoom_level;
  double view_x;
  double view_y;
  double view_w;
  double view_h;
  static int IBITS = 16;
  fractal_thread() {
    //width = 256;
    //height = 192;
    //fractal_image = new short[width][height];
  }
  public void run() {
    while (true) {
      while ((flags & fractalapp.RESET_FLAG) == 0) {
        try {
          sleep(1);
        } catch (java.lang.InterruptedException e) {
          System.out.println(e.getMessage());
        }
      }
       //flags = 0;
       //for (int y2 = 0;y2 < height;y2++) {
       //  for (int x2 = 0;x2 < width;x2++) {
       //    fractal_image[x2][y2] = 0;
       //  }
       //}
      if ((width != new_width) | (height != new_height)) {
        width = new_width;
        height = new_height;
        fractal_image = new short[width][height];
      }

      long t = System.currentTimeMillis(); 
      zoom_level = 6;
      if ((flags & fractalapp.DOUBLE_MAX_ITER_FLAG) != 0) {
       //draw_fractal(0,0,16,16,16,16);
        flags = 0;
        double_max_iter();
      } else {
        flags = 0;
        int a = 1 << (zoom_level-1);
        draw_fractal(0,0,a*2,a*2,a,a);       
        while (zoom_level > 0) {
          a = 1 << (zoom_level-1);
          draw_fractal(a,0,a*2,a*2,a,a*2);
          draw_fractal(0,a,a*2,a*2,a,a);
          draw_fractal(a,a,a*2,a*2,a,a);
          zoom_level = zoom_level - 1;       
          flags = flags | fractalapp.PAINT_FLAG;
	}
      }
      flags = flags | fractalapp.PAINT_FLAG | fractalapp.DONE_FLAG;
       //System.out.println("total_iter3: " + fractalapp.total_iter3);
      long t2 = System.currentTimeMillis()-t; 
    }
  }
  
  void double_max_iter() {
    double dx = view_w / width;
    double dy = view_h / height;
    double fx = view_x;
    double fy = view_y;
    if ((flags & fractalapp.STOP_FLAG) != 0) {return;}
    for (int y3 = 0;y3 < height;y3 = y3 + 1) {
      fy = view_y + (dy*((double)(y3)));
      if ((flags & fractalapp.RESET_FLAG) != 0) {break;}
      if ((flags & fractalapp.STOP_FLAG) != 0) {break;}
      for (int x3 = 0;x3 < width;x3 = x3 + 1) {
        fx = view_x + (dx*((double)(x3)));
        if ((flags & fractalapp.RESET_FLAG) != 0) {break;}  
        int a = get_pixel(x3,y3);
        if (a == -0x8000) {
	  int max_iter = 1 << fractalapp.fractal.max_iter_pow2;
	  int a2 = fractalapp.fractal.calc_point(fx,fy,max_iter);
	  if (a2 == max_iter) {
	    fractal_image[x3][y3] = -0x8000;
	  } else {
	    int max_iter_pow2 = fractalapp.fractal.max_iter_pow2;
	    set_pixel(x3,y3,a2,max_iter_pow2);
	  }
	} else {
	  fractal_image[x3][y3] = (short) (((a+0x8000) >> 1)-0x8000);
	}
      }    
      try {  
	sleep(0);
      } catch (java.lang.InterruptedException e) {
        System.out.println(e.getMessage());
      } 
    }

  }
  int get_pixel(int x,int y) {
    return fractal_image[x][y];
  }
  void set_pixel(int x,int y,int a,int max_iter_pow2) {
    if (max_iter_pow2 >= IBITS) {
      fractal_image[x][y] = (short) ((a >> (max_iter_pow2-IBITS))-0x8000);
    } else {
      fractal_image[x][y] = (short) ((a << (IBITS-max_iter_pow2))-0x8000);
    }    
  }
void draw_fractal(int offset_x,int offset_y,int step_x,int step_y,int rect_w,int rect_h) {
    double dx = view_w / width;
    double dy = view_h / height;
    double fx = view_x;
    double fy = view_y;
    //long total_iter = 0;
    int i43 = 0;
    if ((flags & fractalapp.STOP_FLAG) != 0) {return;}
    for (int y3 = offset_y;y3 < height;y3 = y3 + step_y) {
      fy = view_y + (dy*((double)(y3)));
      if ((flags & fractalapp.RESET_FLAG) != 0) {break;}
      if ((flags & fractalapp.STOP_FLAG) != 0) {break;}
      
      for (int x3 = offset_x;x3 < width;x3 = x3 + step_x) {
        fx = view_x + (dx*((double)(x3)));
        if ((flags & fractalapp.RESET_FLAG) != 0) {break;}  
	int max_iter = 1 << fractalapp.fractal.max_iter_pow2;
	int a = fractalapp.fractal.calc_point(fx,fy,max_iter);
	//}
        //a = a & 0xFC00;
        //while (total_iter >= 1000000) {
        //  total_iter = total_iter - 1000000;
        //  total_iter3 = total_iter3 + 1;
        //}
        //total_iter = total_iter + a;
        for (int y2 = 0;y2 < rect_h;y2++) {
          for (int x2 = 0;x2 < rect_w;x2++) {
            if ((flags & fractalapp.STOP_FLAG) != 0) {break;}
            if (((x3+x2) < width) & ((y3+y2) < height)) {
              if (a == max_iter) {
	        fractal_image[x3+x2][y3+y2] = -0x8000;
	      } else {
	        //double a2 = (((double)a)*512.0) / ((double) fractal->max_iter);
	      //if (a2 >= 256.0) {a2 = 512.0 - a2;} ((char) ((((int) a2) % 255)+1))
	        int max_iter_pow2 = fractalapp.fractal.max_iter_pow2;
	        set_pixel(x3+x2,y3+y2,a,max_iter_pow2);
	      
	      }
	    }
	  }
        }
      }
      
      //if ((i43 & 3) == 0) {
	  try {  
	    sleep(0);
          } catch (java.lang.InterruptedException e) {
            System.out.println(e.getMessage());
          } 
      //}
      i43 = i43 + 1;     
      //System.out.print(id + " ");
    }
  return;
}

}
class new_fractal_windowc extends JDialog implements ActionListener {
  JLabel num_params_label;
  JSpinner num_params_spin_box;
  JLabel seed_label;
  JSpinner seed_spin_box;
  JButton ok_button;
  JButton cancel_button;
  new_fractal_windowc(Frame owner,String title) {
    super(owner,title,false);
    setBounds(0,0,200,100);
    this.getContentPane().setLayout(new GridLayout(3,2));
    num_params_label = new JLabel("num params");
    this.getContentPane().add(num_params_label);
    num_params_spin_box = new JSpinner(new SpinnerNumberModel(8,2,1000,1));    
    this.getContentPane().add(num_params_spin_box);
    
    seed_label = new JLabel("seed");
    this.getContentPane().add(seed_label);
    SpinnerNumberModel m = null;
    Long min = new Long(0x8000000000000000L);
    Long max = new Long(0x7FFFFFFFFFFFFFFFL);
    m = new SpinnerNumberModel(new Long(0),min,max,new Long(1));
    seed_spin_box = new JSpinner(m);    
    this.getContentPane().add(seed_spin_box);
  
    ok_button = create_button("ok","ok");
    cancel_button = create_button("cancel","cancel");
  }
  JButton create_button(String text,String action) {  
    JButton button = new JButton(text);
    button.setActionCommand(action);    
    button.addActionListener(this);
    this.getContentPane().add(button);
    return button;
  }
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    if (action.equals("ok")) {
     Number p = (Number) num_params_spin_box.getValue();
     Number s = (Number) seed_spin_box.getValue();     
     fractalapp.new_fractal(p.intValue(),s.longValue());
     this.setVisible(false);
    } 
    if (action.equals("cancel")) {
      this.setVisible(false);
    
    } 
  }
}
class Colors_windowc extends JFrame implements ActionListener,ChangeListener {
  JLabel hue_label;
  JLabel freq_label;
  JLabel phase_label;
  JLabel dummy_label;
  JLabel label[];
  JSpinner freq_spin_box[];
  JSpinner phase_spin_box[];
  String hue_name[] = {"red","green","blue"};
  boolean auto_update_palette = true;
  Colors_windowc() {
    //super(title);
    setBounds(0,0,240,200);
    this.getContentPane().setLayout(new GridLayout(5,3));
    hue_label = new JLabel("hue");
    this.getContentPane().add(hue_label);
    freq_label = new JLabel("freq");
    this.getContentPane().add(freq_label);
    phase_label = new JLabel("phase");
    this.getContentPane().add(phase_label);
    label = new JLabel[3];
    freq_spin_box = new JSpinner[3];
    phase_spin_box = new JSpinner[3];
    for (int i = 0;i < 3;i++) {
     label[i] = new JLabel(hue_name[i]);
     this.getContentPane().add(label[i]);
     freq_spin_box[i] = new JSpinner(new SpinnerNumberModel(1,1,63,1));
     this.getContentPane().add(freq_spin_box[i]);
     freq_spin_box[i].addChangeListener(this);
     phase_spin_box[i] = new JSpinner(new SpinnerNumberModel(0,0,63,2));
     this.getContentPane().add(phase_spin_box[i]);
     phase_spin_box[i].addChangeListener(this);
    }
    dummy_label = new JLabel("");
    this.getContentPane().add(dummy_label);
    create_button("apply","apply");
    create_button("close","close");
  }
  JButton create_button(String text,String action) {  
    JButton button = new JButton(text);
    button.setActionCommand(action);    
    button.addActionListener(this);
    this.getContentPane().add(button);
    return button;
  }
  void update_spinboxes() {
    boolean b = auto_update_palette;
    auto_update_palette = false;
    for (int i = 0;i < 3;i++) {
       int f = fractalapp.color_hue_freq[i];
       freq_spin_box[i].setValue(new Integer(f));
       int p = fractalapp.color_hue_phase[i];
       phase_spin_box[i].setValue(new Integer(p));
    }
    auto_update_palette = b;
  }
  void update_palette() {
      for (int i = 0;i < 3;i++) {
        Number n = (Number) freq_spin_box[i].getValue();
        fractalapp.color_hue_freq[i] = n.shortValue();
        n = (Number) phase_spin_box[i].getValue();
        fractalapp.color_hue_phase[i] = n.shortValue();
      }
      fractalapp.update_palette();
      fractalapp.fractalmainwindow.repaint();
  }
  public void stateChanged(ChangeEvent e) {
    if (auto_update_palette == true) {
      update_palette();
    }
  }
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    if (action.equals("apply")) {
      update_palette();
    }
    if (action.equals("close")) {
      this.hide();
    }
  }
}

class fractalmainpanelc extends JPanel implements MouseListener{
  static int thumbnail_width = 100;
  static int thumbnail_height = 75;
  static int thumbnail_size = 8420;
  int last_x;
  int last_y;
  Image img;
  int pix[];
  short old_color_hue_freq[];
  short old_color_hue_phase[];
  static int PALETTE_SIZE = 8;
  fractalmainpanelc() {
    int w = fractalapp.block_width;
    int h = fractalapp.block_height;
    pix = new int[(w * h)];
    this.addMouseListener(this);
    old_color_hue_freq = new short[3];
    old_color_hue_phase = new short[3];
  }
  protected void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (fractalapp.menu_mode == true) {    
      paint_menu(g);
    } else {
      paint(g,true);    
    }
  }
  public void paint_menu(Graphics g) {
    //System.out.println("paint_menu");
    int w3 = thumbnail_width;
    int h3 = thumbnail_height;
    try {
      //BufferedInputStream i = new BufferedInputStream(new FileInputStream(fractalapp.filename));
      java.net.URL thumbnail_URL = fractalapp.class.getResource(fractalapp.filename);
      DataInputStream in = new DataInputStream(new BufferedInputStream(thumbnail_URL.openStream()));
      for (int i2 = 0;i2 < 3;i2++) {
        old_color_hue_freq[i2] = fractalapp.color_hue_freq[i2];
        old_color_hue_phase[i2] = fractalapp.color_hue_phase[i2];
      }
      int y3 = 0;
      for (int y = 0;y < 10;y++) {
        int x3 = 0;
        for (int x = 0;x < 10;x++) {
          for (int y2 = 0;y2 < h3;y2++) {
            for (int x2 = 0;x2 < w3;x2++) {
              int b = in.read();
              pix[x2+(y2*w3)] = b;
            }
  	  }
          for (int i2 = 0;i2 < 3;i2++) {
            fractalapp.color_hue_freq[i2] = (short) (in.readShort());
            fractalapp.color_hue_phase[i2] = (short) (in.readShort());
	  }
	  fractalapp.update_palette256();	  
          for (int y2 = 0;y2 < h3;y2++) {
            for (int x2 = 0;x2 < w3;x2++) {
	      pix[x2+(y2*w3)] = fractalapp.palette256[pix[x2+(y2*w3)]];
	    }
	  }
	  int s = thumbnail_size-(w3*h3)-12;
	  while (s > 0) {
	    s = s - (int)in.skip(s);
	  }
	  img = createImage(new MemoryImageSource(w3, h3, pix, 0, w3));
          g.drawImage(img,x3,y3,null);    
          x3 = x3 + w3 + 1;
        }
        y3 = y3 + h3 + 1;
      }
      in.close();
      for (int i2 = 0;i2 < 3;i2++) {
        fractalapp.color_hue_freq[i2] = old_color_hue_freq[i2];
        fractalapp.color_hue_phase[i2] = old_color_hue_phase[i2];
      }
      fractalapp.update_palette();
    
    } catch (IOException e) {
      e.printStackTrace();
    }    
  }
  public void paint(Graphics g,boolean b) {
    int PAINT_FLAG = fractalapp.PAINT_FLAG;
    int x3 = 0;
    int y3 = 0;
    int w3 = 0;
    int h3 = 0;
    for (int x = 0;x < 4;x++) {
      w3 = fractalapp.image_block[x][0].width;
      y3 = 0;
      for (int y = 0;y < 4;y++) {
        h3 = fractalapp.image_block[x][y].height;
        if (((fractalapp.image_block[x][y].flags & PAINT_FLAG) != 0) | b) {
          for (int x2 = 0;x2 < w3;x2++) {
            for (int y2 = 0;y2 < h3;y2++) {
              int a = fractalapp.image_block[x][y].get_pixel(x2,y2);
              pix[x2+(y2*w3)] = fractalapp.palette[(a+0x8000) >> (16-PALETTE_SIZE)];
	      //pix[x2+(y2*w3)] = fractalapp.palette[a+0x8000];
              //if (a == 0) {
              //  pix[x2+(y2*w3)] = 0xFF000000;
              //} else {
              //  pix[x2+(y2*w3)] = 0xFFFFFFFF;
              //}
            }
          }
          if (b == false) {
            fractalapp.image_block[x][y].flags = fractalapp.image_block[x][y].flags ^ PAINT_FLAG;
          }
          long t = System.currentTimeMillis();           
	  //System.out.println("paint time:" + t);
	  img = createImage(new MemoryImageSource(w3, h3, pix, 0, w3));
          g.drawImage(img,x3,y3,null);
        }
        y3 = y3 + h3;
      }
      x3 = x3 + w3;
    }
  }
  Image get_full_image() {
    int w = fractalapp.block_width*4;
    int h = fractalapp.block_height*4;
    int pix2[] = new int[(w * h)];
    fractalapp.update_palette();
    for (int x = 0;x < w;x++) {
      for (int y = 0;y < h;y++) {
        int a = fractalapp.image_block[x/w][y/h].fractal_image[x%w][y%h];
	pix[x+(y*w)] = fractalapp.palette[(a+0x8000) >> (16-PALETTE_SIZE)];
      }
    }
    img = createImage(new MemoryImageSource(w, h, pix, 0, w));
    return img; 
  }
  public void mouseClicked(MouseEvent e) {
    int x = e.getX();    
    int y = e.getY();        
    int b = e.getButton();
    if (fractalapp.menu_mode == true) {
      int w3 = fractalmainpanelc.thumbnail_width + 1;
      int h3 = fractalmainpanelc.thumbnail_height + 1;
      int x2 = x / w3;
      int y2 = y / h3;
      if ((x2 < 10) & (y2 < 10)) {
        fractalmainwindowc.load_fractal_from_menu((y2*10)+x2);
      }
    }
  }
  public void mouseEntered(MouseEvent e) {
  }
  public void mouseExited(MouseEvent e) {
  }
  public void mousePressed(MouseEvent e) {
    int x = e.getX();    
    int y = e.getY();        
    last_x = x;
    last_y = y;
  }      
  public void mouseReleased(MouseEvent e) {
    int x = e.getX();    
    int y = e.getY();        
    double fw = (double) (fractalapp.block_width*4);
    double fh = (double) (fractalapp.block_height*4);
   
    double fw2 = fractalapp.fractal.view_w;
    double fh2 = fractalapp.fractal.view_h;
    
    if ((last_x != x) & (last_y != y)) {
      double fx1 = ((double) last_x);
      double fy1 = ((double) last_y);      
      double fx2 = ((double) x);
      double fy2 = ((double) y);
      fx1 = (fx1 * fw2) / fw;
      fy1 = (fy1 * fh2) / fh;
      fx2 = (fx2 * fw2) / fw;
      fy2 = (fy2 * fh2) / fh;
      if (fx1 < fx2) {
        fractalapp.fractal.view_x = fractalapp.fractal.view_x + fx1;
        fractalapp.fractal.view_w = fx2-fx1;
      } else {
        fractalapp.fractal.view_x = fractalapp.fractal.view_x + fx2;
        fractalapp.fractal.view_w = fx1-fx2;      
      }
      if (fy1 < fy2) {
        fractalapp.fractal.view_y = fractalapp.fractal.view_y + fy1;
        fractalapp.fractal.view_h = fy2-fy1;
      } else {
        fractalapp.fractal.view_y = fractalapp.fractal.view_y + fy2;
        fractalapp.fractal.view_h = fy1-fy2;      
      }
      fractalapp.recalc();
    } else {
      fractalapp.zoom_out();
      fractalapp.recalc();
    }
  }  
}
class applet_button_panelc extends JPanel implements ActionListener{
  applet_button_panelc() {
    //GridLayout gl = new GridLayout(1,4);
    //this.setLayout(gl);
    create_button("menu","menu");
    create_button("mode","mode");
    create_button(createImageIcon("up.png","move up"),"up");
    create_button(createImageIcon("down.png","move down"),"down");
    create_button(createImageIcon("left.png","move left"),"left");
    create_button(createImageIcon("right.png","move right"),"right");
    create_button(createImageIcon2("zoom_in.png"),"zoom_in");
    create_button(createImageIcon2("zoom_out.png"),"zoom_out");
  }
  JButton create_button(String title,String action) {  
    JButton button = new JButton(title);
    button.setActionCommand(action);    
    button.addActionListener(this);
    this.add(button);
    return button;
  }
  JButton create_button(ImageIcon img,String action) {  
    JButton button = new JButton(img);
    button.setActionCommand(action);    
    button.addActionListener(this);
    this.add(button);
    return button;
  }
  static ImageIcon createImageIcon2(String path) {
    java.net.URL imgURL = applet_button_panelc.class.getResource(path);
    if (imgURL != null) {
      return new ImageIcon(imgURL);
    } else {
      System.err.println("Couldn't find file: " + path);
      return null;
    }
  }

  static ImageIcon createImageIcon(String path, String description) {
    java.net.URL imgURL = applet_button_panelc.class.getResource(path);
    if (imgURL != null) {
      return new ImageIcon(imgURL, description);
    } else {
      System.err.println("Couldn't find file: " + path);
      return null;
    }
  }
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    if (action.equals("menu")) {
        fractalapp.menu_mode = !fractalapp.menu_mode;
        if (fractalapp.menu_mode == false) {
          fractalapp.recalc();
        }
    }
    if (action.equals("mode")) {
        if (fractalapp.fractal.is_julia_mode_on()) {
          fractalapp.fractal.use_mandelbrot_mode();
        } else {
          fractalapp.fractal.use_julia_mode();              
        }
        fractalapp.recalc();
    }
    if (action.equals("up")) {
      fractalapp.move_up();
    }
    if (action.equals("down")) {
      fractalapp.move_down();
    }
    if (action.equals("left")) {
      fractalapp.move_left();
    }
    if (action.equals("right")) {
      fractalapp.move_right();
    }
    if (action.equals("zoom_in")) {
        fractalapp.zoom_in();
        fractalapp.recalc();
    }
    if (action.equals("zoom_out")) {
        fractalapp.zoom_out();
        fractalapp.recalc();
    }

  }
}
class keys_windowc extends JFrame {
  public JScrollPane text2; 
  public JTextArea text; 
  
  keys_windowc(String title) {
    super(title);
    text = new JTextArea();
    text2 = new JScrollPane(text);    
    this.getContentPane().add(text2);
    show_keys();
    this.pack();    
  }
  
  void show_keys() {
    text.append("When the program starts, it shows a menu of fractals.\n");
    text.append("Click on any fractal with mouse to view it.\n");
    text.append("Tip: you can also type in a 2 digit number to view it.\n\n");
    text.append("Now here are the keys:\n");
    text.append("J key: switch between mandelbrot and julia modes\n");
    text.append("M key: show the menu\n");
    text.append("Arrow keys: move around\n");
    text.append("Ctrl+O: open a fractal\n");    
    text.append("Ctrl+S: save a fractal\n");    
    text.append("Ctrl+I: double max iterations\n");
    text.append("Ctrl+C: edit colors\n");        
    text.append("plus key: Zoom in\n");
    text.append("minus key: Zoom out\n\n");
    text.append("tip: you can also zoom in or out with the mouse.\n");
    text.append("To zoom in, select an area with mouse.\n"); 
    text.append("To zoom out, click on the fractal.\n");             
    text.setEditable(false);
  }  
  

}
class taskPerformer implements ActionListener {
  fractalmainpanelc fractalmainpanel;
  boolean menu_visible = false;
  taskPerformer(fractalmainpanelc p) {
    fractalmainpanel = p;
  }
  public void actionPerformed(ActionEvent evt) {
    Graphics g = fractalmainpanel.getGraphics();
    if (fractalapp.menu_mode == false) {
     menu_visible = false; 
     fractalmainpanel.paint(g,false);
    } else if (menu_visible == false) {
      fractalmainpanel.repaint();
      menu_visible = true;
    }
  }
};

class fractalmainwindowc extends JFrame implements ActionListener,WindowListener,KeyListener {
  static char last_digit = 0;
  fractalmainpanelc fractalmainpanel;
  JLabel statusbar;
  JCheckBoxMenuItem mi_statusbar;
  keys_windowc keys_window;
  new_fractal_windowc new_fractal_window;
  fractalmainwindowc() {
    SpringLayout spl = new SpringLayout();
    JMenuBar mb = new JMenuBar();

    JMenu m = new JMenu("file");
    mb.add(m);
    JMenuItem minew = new JMenuItem("new");
    m.add(minew);
    minew.setActionCommand("menunew");    
    minew.addActionListener(this);
          
    JMenuItem miopen = new JMenuItem("open");
    m.add(miopen);
    miopen.setActionCommand("menuopen");    
    miopen.addActionListener(this);
          
    JMenuItem misave = new JMenuItem("save");
    m.add(misave);
    misave.setActionCommand("menusave");    
    misave.addActionListener(this);
    
    JMenuItem miexit = new JMenuItem("exit");
    m.add(miexit);
    miexit.setActionCommand("menuexit");    
    miexit.addActionListener(this);


    m = new JMenu("fractal");
    mb.add(m);

    JMenuItem midbl = new JMenuItem("double max iter");
    m.add(midbl);
    midbl.setActionCommand("menu_double");    
    midbl.addActionListener(this);

    JMenuItem micolors = new JMenuItem("edit colors");
    m.add(micolors);
    micolors.setActionCommand("menu_colors");    
    micolors.addActionListener(this);
    
    m = new JMenu("help");
    mb.add(m);

    JMenuItem mikeys = new JMenuItem("show the keys");
    m.add(mikeys);
    mikeys.setActionCommand("menu_keys");    
    mikeys.addActionListener(this);
        
        
    //mi_statusbar = new JCheckBoxMenuItem("show status bar");
    //m.add(mi_statusbar);
    //mi_statusbar.setActionCommand("menu_status_bar");    
    //mi_statusbar.addActionListener(this);
    

    
    fractalmainpanel = new fractalmainpanelc();
    //this.getContentPane().setLayout(spl);

    //spl.putConstraint(SpringLayout.EAST,fractalmainpanel,0,SpringLayout.EAST,this.getContentPane());
    //spl.putConstraint(SpringLayout.WEST,fractalmainpanel,0,SpringLayout.WEST,this.getContentPane());

    //statusbar = new JLabel("status bar");
    //spl.putConstraint(SpringLayout.SOUTH,statusbar,0,SpringLayout.SOUTH,this.getContentPane());
    //spl.putConstraint(SpringLayout.SOUTH,fractalmainpanel,0,SpringLayout.NORTH,statusbar);
    //spl.putConstraint(SpringLayout.NORTH,fractalmainpanel,0,SpringLayout.NORTH,this.getContentPane());


    this.setJMenuBar(mb);        
    this.setBounds(0,0,1020,810);
    //this.getContentPane().add(statusbar);
    this.getContentPane().add(fractalmainpanel);
    this.setVisible(true);
    this.addWindowListener(this);
    update_status_bar();
    this.addKeyListener(this);
    new javax.swing.Timer(100, new taskPerformer(fractalmainpanel)).start();    

  }
  void update_status_bar() {
    if (statusbar != null) {
      String str = fractalapp.fractal.get_status_text();
      statusbar.setText(" " + str);
    }
  }
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    if (action.equals("menunew")) {
      //fractalapp.new_fractal();
      if (new_fractal_window == null) {
        new_fractal_window = new new_fractal_windowc(this,"new fractal");        
      }
      new_fractal_window.setVisible(true);
    }
    if (action.equals("menuopen")) {
        fractalapp.open2();
    }
    if (action.equals("menusave")) {
        fractalapp.save2();
    }
    if (action.equals("menuexit")) {
      try {
        System.exit(0);
      } catch(SecurityException err) {
        System.out.println("can not exit");
      }
    }
    if (action.equals("menu_double")) {
        fractalapp.double_max_iter();
    }
    if (action.equals("menu_colors")) {
        fractalapp.Colors_window.show();
    }
    //if (action.equals("menu_random")) {
        //fractalapp.fractal.random();
        //fractalapp.recalc();
    //}
    if (action.equals("menu_keys")) {
      if (keys_window == null) {
        keys_window = new keys_windowc("the keys");      
      }
      keys_window.setVisible(true);
    }
    //if (action.equals("menu_status_bar")) {
        //if (mi_statusbar.getState() == true) {
	//  this.getContentPane().add(statusbar);
        //} else {
	//  this.getContentPane().remove(statusbar);	
	//}
    //}
  }
  public void windowActivated(WindowEvent e) {
    //System.out.println("Activated event");
    this.requestFocusInWindow();
    fractalmainpanel.repaint();
  }
  public void windowClosed(WindowEvent e) {
    //System.out.println("Close event");
  }
  public void windowClosing(WindowEvent e) {
    //System.out.println("Closing event");
    try {
      System.exit(0);
    } catch(SecurityException err) {
      System.out.println("can not exit");
    }
  }
  public void windowDeactivated(WindowEvent e) {
    //System.out.println("Deactivated event");
  }
  public void windowDeiconified(WindowEvent e) {
    //System.out.println("Deiconified event");
  }
  public void windowIconified(WindowEvent e) {
    //System.out.println("Iconified event");
  }
  public void windowOpened(WindowEvent e) {
    //System.out.println("Opened event");
  }
  static void load_fractal_from_menu(int i) {
    try {  
      java.net.URL thumbnail_URL = fractalapp.class.getResource(fractalapp.filename);
      DataInputStream in = new DataInputStream(new BufferedInputStream(thumbnail_URL.openStream()));
      int w3 = fractalmainpanelc.thumbnail_width;
      int h3 = fractalmainpanelc.thumbnail_height;
      int s3 = fractalmainpanelc.thumbnail_size;
    
      int s = (s3*i)+(w3*h3);
      while (s > 0) {
        s = s - (int)in.skip(s);
      }
      for (int i2 = 0;i2 < 3;i2++) {
        fractalapp.color_hue_freq[i2] = in.readShort();
        fractalapp.color_hue_phase[i2] = in.readShort();
      }
      int t = in.readInt();
      abstract_fractalc f = abstract_fractalc.get_new_fractal(t);
      //f.mode = in.readInt();
      f.max_iter_pow2 = in.readInt();
      //System.out.println("f.max_iter_pow2: " + f.max_iter_pow2);
      f.mode = (f.max_iter_pow2 >> 31)&1;
      f.max_iter_pow2 = f.max_iter_pow2&255;
      //System.out.println("f.mode: " + f.mode);
      //int id17 = in.readInt();
      f.view_x_m = in.readDouble();
      f.view_w_m = in.readDouble();
      f.view_y_m = in.readDouble();
      f.view_h_m = in.readDouble();
      f.view_x = in.readDouble();
      f.view_w = in.readDouble();
      f.view_y = in.readDouble();
      f.view_h = in.readDouble();
      //System.out.println(id17);
      f.read(in);
      fractalapp.fractal = f;
      //System.out.println(f.view_x_m + ", " + f.view_y_m + ", " + f.view_w_m + ", " + f.view_h_m);     System.out.println(f.view_x + ", " + f.view_y + ", " + f.view_w + ", " + f.view_h);
      fractalapp.menu_mode = false;
      fractalapp.recalc();
      fractalapp.update_palette();
      fractalapp.Colors_window.update_spinboxes();
      in.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  public void keyTyped(KeyEvent e) {
    char c = e.getKeyChar();
      if (fractalapp.menu_mode == true) {
        char ch = c;
	if ((ch >= '0') & (ch <= '9')) {
          char ch2 = last_digit;
          if ((ch2 >= '0') & (ch2 <= '9')) {
            int i = ((ch2-'0')*10)+(ch-'0');
	    fractalmainwindowc.load_fractal_from_menu(i);
            last_digit = 0;
          } else {
            last_digit = ch;
          }
        }
      }
      if (c == 'j') {
        if (fractalapp.fractal.is_julia_mode_on()) {
          fractalapp.fractal.use_mandelbrot_mode();
        } else {
          fractalapp.fractal.use_julia_mode();              
        }
        fractalapp.recalc();
      }
      if (c == 'm') {
        fractalapp.menu_mode = !fractalapp.menu_mode;
        if (fractalapp.menu_mode == false) {
          fractalapp.recalc();
        }
      }
      if (c == '<') {
        fractalapp.fractal.prev_mode();    
        fractalapp.recalc();
        update_status_bar();
      }
      if (c == '>') {
        fractalapp.fractal.next_mode();    
        fractalapp.recalc();
        update_status_bar();
      }
      if ((c == '+') | (c == '=')) {
        fractalapp.zoom_in();
        fractalapp.recalc();
      }
      if ((c == '-') | (c == '_')) {
        fractalapp.zoom_out();
        fractalapp.recalc();
      }
  }

  public void keyPressed(KeyEvent e) {
    int a = e.getKeyCode();
    boolean ctrl = e.isControlDown();
    if (ctrl) {
      //if (a == KeyEvent.VK_R) {
      //  fractalapp.fractal.random();
      //  fractalapp.recalc();
      //}
      if (a == KeyEvent.VK_I) {
        fractalapp.double_max_iter();
      }
      if (a == KeyEvent.VK_C) {
        fractalapp.Colors_window.show();
      }
      if (a == KeyEvent.VK_O) {
        fractalapp.open2();
      }
      if (a == KeyEvent.VK_S) {
        fractalapp.save2();
      }
    }
    if (a == KeyEvent.VK_LEFT) {
      fractalapp.move_left();
    }
    if (a == KeyEvent.VK_RIGHT) {
      fractalapp.move_right();
    }
    if (a == KeyEvent.VK_UP) {
      fractalapp.move_up();
    }
    if (a == KeyEvent.VK_DOWN) {
      fractalapp.move_down();

    }
  }

  public void keyReleased(KeyEvent e) {
  }
  
}
class MyImageWriteParam extends JPEGImageWriteParam { 
  public MyImageWriteParam() { super(Locale.getDefault()); } 
  public void setCompressionQuality(float quality) { 
    if (quality < 0.0F || quality > 1.0F) { 
      throw new IllegalArgumentException("Quality out-of-bounds!"); 
    } this.compressionQuality = 256 - (quality * 256); 
  } 
} 

class fractalapp implements Runnable {
  static String filename = "thumbnails1001a1";  
  static int block_width = 256;
  static int block_height = 192;
  static int STOP_FLAG = 1;
  static int PAINT_FLAG = 2;
  static int DONE_FLAG = 4;
  static int RESET_FLAG = 8;
  static int DOUBLE_MAX_ITER_FLAG = 16;
  static abstract_fractalc fractal;
  static fractal_thread image_block[][];
  static fractalmainwindowc fractalmainwindow;
  static Colors_windowc Colors_window;
  static int ALLOC_PALETTE_SIZE = 8;
  static int palette[];  
  static int palette256[];
  static short color_hue_freq[] = {1,1,1}; 
  static short color_hue_phase[] = {0,10,20};
  static boolean menu_mode = true;
  static int fractal_info_id[] = {713045539,657324493,355472293,961271078,
  -1030162707,-613333504,-330822319,-655859188};
  static void init() {
    int PALETTE_SIZE = fractalmainpanelc.PALETTE_SIZE;
    palette = new int[1 << ALLOC_PALETTE_SIZE];
    palette256 = new int[256];
    fractalapp.update_palette256();
    fractal = abstract_fractalc.get_new_fractal(1400000008);
    //fractal = new fractal_params_c(8);
    image_block = new fractal_thread[4][4];
    for (int x = 0;x < 4;x++) {
      for (int y = 0;y < 4;y++) {
        image_block[x][y] = new fractal_thread();
        image_block[x][y].id = (y*4)+x;
	image_block[x][y].new_width = block_width;
        image_block[x][y].new_height = block_height;
	image_block[x][y].start();
      }
    }
    Colors_window = new Colors_windowc();
  }
  public static void main(String[] args ){
    init();
    javax.swing.SwingUtilities.invokeLater(new fractalapp());
  }
  static void new_fractal(int p,long s) {
      //String str = JOptionPane.showInputDialog("how many params?");
      //if (str != null) {
      //int p = Integer.parseInt(str);
      abstract_fractalc fc = abstract_fractalc.get_new_fractal(1400000000+p);
      if (fc != null) {
        fractalapp.fractal = fc;
        fractalapp.fractal.random(s);
        fractalapp.recalc();
      }
      //}
  }
  public void run() {          
    fractalmainwindow = new fractalmainwindowc();
    //recalc();
  }
  static void open2() {
    FileDialog fd = new FileDialog(fractalmainwindow,"load fractal",FileDialog.LOAD);
    fd.show();
    String filename = fd.getDirectory() + fd.getFile();
    if (fd.getFile() != null){
      try {
        open(filename);
      } catch (Exception err) {
        err.printStackTrace();
      }
    }
  }
  static void open(String filename) throws IOException {
    DataInputStream in = new DataInputStream(
    new BufferedInputStream(new FileInputStream(filename)));
    File f = new File(filename);
    long l = f.length();
    for (long p = 0;p < l;p = p + 32) {
      boolean fractal_info_id_found = true;
      for (int i = 0;i < 8;i++) {
        int id = in.readInt();
        if (fractal_info_id[i] != id) {
          fractal_info_id_found = false;
        }
      }
      if (fractal_info_id_found == true) {
        int ft = in.readInt();
        abstract_fractalc fc = abstract_fractalc.get_new_fractal(ft);
        if (fc != null) {
          fractal = fc;
          in.readInt();
          in.readInt();
          in.readInt();
          in.readInt();
          in.readInt();
          in.readInt();
          in.readInt();
          int s = in.readInt();
	  for (int i = 0;i < s;i++) {
	    in.readByte();
	  }
          fractal.mode = in.readShort();
          fractal.mode = fractal.mode & 1;
          fractal.max_iter_pow2 = in.readShort();
          fractal.view_x_m = in.readDouble();
          fractal.view_w_m = in.readDouble();
          fractal.view_y_m = in.readDouble();
          fractal.view_h_m = in.readDouble();
          fractal.view_x = in.readDouble();
          fractal.view_w = in.readDouble();
          fractal.view_y = in.readDouble();
          fractal.view_h = in.readDouble();
          for (int i = 0;i < 3;i++) {
            color_hue_freq[i] = in.readShort();
            color_hue_phase[i] = in.readShort();
          }
          fractal.read(in);
        }
        break;
      }
    }
    in.close();
    menu_mode = false;
    Colors_window.update_spinboxes();
    recalc();
  }
  static void writeJpegFile(RenderedImage rendImage,File outfile, float compressionQuality) { 
  try { 
    ImageWriter writer = null; 
    Iterator iter = ImageIO.getImageWritersByFormatName("jpg"); 
    if (iter.hasNext()) { writer = (ImageWriter)iter.next(); } 
    ImageOutputStream ios = ImageIO.createImageOutputStream(outfile); 
    writer.setOutput(ios); 
    ImageWriteParam iwparam = new MyImageWriteParam(); iwparam.setCompressionMode(ImageWriteParam.MODE_EXPLICIT) ; iwparam.setCompressionQuality(compressionQuality);
    writer.write(null, new IIOImage(rendImage, null, null), iwparam); 
    ios.flush(); 
    writer.dispose(); 
    ios.close(); 
  } catch (IOException e) { 
  } 
} 
  static void save2() {
    FileDialog fd = new FileDialog(fractalmainwindow,"save fractal",FileDialog.SAVE);
    fd.show();
    String filename = fd.getDirectory() + fd.getFile();
    if (fd.getFile() != null){
      try {
        save(filename);
      } catch (Exception err) {
        System.out.println(err.getMessage());
      }
    }
  }
  static void save(String filename) throws IOException {
    BufferedImage img = new BufferedImage(1024,768,BufferedImage.TYPE_INT_RGB);
    Graphics g = img.getGraphics();
    fractalmainwindow.fractalmainpanel.paint(g,true);
    //writeJpegFile(img,new File(filename),0.8f);
    File f = new File(filename);
    ImageIO.write(img,"JPG",f);
    long p = f.length();

    DataOutputStream out = new DataOutputStream(
    new BufferedOutputStream(new FileOutputStream(filename,true)));
    //System.out.println("p:" + p);
    while ((p & 31) != 0) {
      out.writeByte(0);
      p = p + 1;
    }
    for (int i = 0;i < 8;i++) {
      out.writeInt(fractal_info_id[i]);
    }
    int ft = fractal.get_fractal_type();
    out.writeInt(ft);
    out.writeInt(0);
    out.writeInt(0);
    out.writeInt(0);
    out.writeInt(0);
    out.writeInt(0);
    out.writeInt(0);
    out.writeInt(0);
    out.writeInt(0);
    out.writeShort(fractal.mode);
    out.writeShort(fractal.max_iter_pow2);
    out.writeDouble(fractal.view_x_m);
    out.writeDouble(fractal.view_w_m);
    out.writeDouble(fractal.view_y_m);
    out.writeDouble(fractal.view_h_m);
    out.writeDouble(fractal.view_x);
    out.writeDouble(fractal.view_w);
    out.writeDouble(fractal.view_y);
    out.writeDouble(fractal.view_h);
    for (int i = 0;i < 3;i++) {
      out.writeShort(color_hue_freq[i]);
      out.writeShort(color_hue_phase[i]);
    }
    fractal.write(out);
    out.close();
  }
  static void update_palette256() {
    palette256[0] = 0xFF000000;
    for (int i = 1;i < 256;i++) {
      palette256[i] = get_color32(i*256);
    }
  }
  static void update_palette() {
    int PALETTE_SIZE = fractal.max_iter_pow2;
    if (PALETTE_SIZE > 16) {PALETTE_SIZE = 16;}
    if (PALETTE_SIZE > ALLOC_PALETTE_SIZE) {
      ALLOC_PALETTE_SIZE = PALETTE_SIZE;
      palette = new int[1 << PALETTE_SIZE];    
    }
    palette[0] = 0xFF000000;
    for (int i = 1;i < (1<<PALETTE_SIZE);i++) {
      palette[i] = get_color32((i << (16-PALETTE_SIZE)));
    }
    fractalmainpanelc.PALETTE_SIZE = PALETTE_SIZE;
  }
  static int get_color32(int i) {
    if (i == 0) {return 0;}
    int r = get_color_hue_value2(i,2);
    int g = get_color_hue_value2(i,1);
    int b = get_color_hue_value2(i,0);
    return (255 << 24) + (b << 16) + (g << 8) + r;
  }
  static int get_color_hue_value2(int i,int i2) {
    int f = color_hue_freq[i2];
    int p = color_hue_phase[i2];

    return (int) ((1.0-Math.cos((((((double) i) * f) + (p*4*256)) * Math.PI*2) / 65536.0))*127.0);
  }
  static void move_up() {
      for (int y = 3;y >= 1;y--) {
        for (int x = 0;x < 4;x++) {
          fractal_thread tmp = image_block[x][y];
          image_block[x][y] = image_block[x][y-1];
          image_block[x][y].flags = image_block[x][y].flags | PAINT_FLAG;
          image_block[x][y-1] = tmp;
        }
      }
      double f34 = fractal.view_h / 4.0;
      fractal.view_y = fractal.view_y - f34;
      for (int x = 0;x < 4;x++) {
        image_block[x][0].flags = 0;
        calc160(x,0);
      }  
  }
  static void move_down() {
    for (int y = 0;y < 3;y++) {
      for (int x = 0;x < 4;x++) {
        fractal_thread tmp = image_block[x][y];
        image_block[x][y] = image_block[x][y+1];
        image_block[x][y].flags = image_block[x][y].flags | PAINT_FLAG;
        image_block[x][y+1] = tmp;
      }
    }
    double f34 = fractal.view_h / 4.0;
    fractal.view_y = fractal.view_y + f34;
    for (int x = 0;x < 4;x++) {
      image_block[x][3].flags = 0;
      calc160(x,3);
    }
  }
  static void move_left() {
    for (int y = 0;y < 4;y++) {
      for (int x = 3;x >= 1;x--) {
        fractal_thread tmp = image_block[x][y];
        image_block[x][y] = image_block[x-1][y];
        image_block[x][y].flags = image_block[x][y].flags | PAINT_FLAG;
        image_block[x-1][y] = tmp;
      }
    }
    double f34 = fractal.view_w / 4.0;
    fractal.view_x = fractal.view_x - f34;
    for (int y = 0;y < 4;y++) {
      image_block[0][y].flags = 0;
      calc160(0,y);
    }      
  }
  static void move_right() {
    for (int y = 0;y < 4;y++) {
      for (int x = 0;x < 3;x++) {
        fractal_thread tmp = image_block[x][y];
        image_block[x][y] = image_block[x+1][y];
        image_block[x][y].flags = image_block[x][y].flags | PAINT_FLAG;
        image_block[x+1][y] = tmp;
      }
    }
    double f34 = fractal.view_w / 4.0;
    fractal.view_x = fractal.view_x + f34;
    for (int y = 0;y < 4;y++) {
      image_block[3][y].flags = 0;
      calc160(3,y);
    }

  }
static void zoom_in() {
    double new_view_x = -1.5;
    double new_view_y = -1.0;
    double new_view_w = 2.0;
    double new_view_h = 2.0;
    new_view_x = fractal.view_x + (fractal.view_w / 4);
    new_view_w = fractal.view_w / 2;
    new_view_y = fractal.view_y + (fractal.view_h / 4);
    new_view_h = fractal.view_h / 2;
    fractal.view_x = new_view_x;
    fractal.view_w = new_view_w;
    fractal.view_y = new_view_y;
    fractal.view_h = new_view_h;
}
static void zoom_out() {
    double new_view_x = -1.5;
    double new_view_y = -1.0;
    double new_view_w = 2.0;
    double new_view_h = 2.0;

    new_view_x = fractal.view_x - (fractal.view_w / 2);
    new_view_w = fractal.view_w * 2;
    new_view_y = fractal.view_y - (fractal.view_h / 2);
    new_view_h = fractal.view_h * 2;
    fractal.view_x = new_view_x;
    fractal.view_w = new_view_w;
    fractal.view_y = new_view_y;
    fractal.view_h = new_view_h;
}
static void calc160(int x,int y) {
  double fx = ((double) x);
  double fy = ((double) y);
  //printf("calc160 %d %d \n",x,y);
  image_block[x][y].view_x = fractal.view_x + ((fractal.view_w*fx) / 4.0);
  image_block[x][y].view_y = fractal.view_y + ((fractal.view_h*fy) / 4.0);
  image_block[x][y].view_w = fractal.view_w / 4.0;
  image_block[x][y].view_h = fractal.view_h / 4.0;
  image_block[x][y].flags = image_block[x][y].flags | RESET_FLAG;

}


static void double_max_iter() {
  fractal.max_iter_pow2 = fractal.max_iter_pow2 + 1;
  for (int y = 0;y < 4;y++) {
    for (int x = 0;x < 4;x++) {
      int f = RESET_FLAG | DOUBLE_MAX_ITER_FLAG;
      image_block[x][y].flags = f;
    }
  }
}
static void recalc() {
  long t = System.currentTimeMillis(); 
  //System.out.println("recalc: " + t);
    for (int y = 0;y < 4;y++) {
      for (int x = 0;x < 4;x++) {
        calc160(x,y);
      }
    }
}

}
